--********************************DISCLAIMER**************************************
--We do not support 32-bit versions of SQL Server due to memory constraints
--********************************************************************************

-- UDF_mdName.sql
--
-- Adds the mdName user-defined functions to SQL Server.
--
-- You must have copied mdName.dll into the /Binn/ folder of you
--   SQL Server installation AND have already executed the
--   xp_mdName.sql script before running this script.

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameCreate') AND type='FN')
BEGIN
  DROP FUNCTION mdNameCreate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameCreate') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		CREATE FUNCTION mdNameCreate ()
		RETURNS INT AS BEGIN
			DECLARE @mdName INT
			EXECUTE master.dbo.xp_mdNameCreate @mdName OUT
			RETURN @mdName
		END
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameDestroy') AND type='FN')
BEGIN
  DROP FUNCTION mdNameDestroy
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameDestroy') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		CREATE FUNCTION mdNameDestroy (@mdName int)
		RETURNS INT AS BEGIN
			EXECUTE master.dbo.xp_mdNameDestroy @mdName
			RETURN NULL
		END
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPathToNameFiles') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetPathToNameFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPathToNameFiles') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	CREATE FUNCTION mdNameSetPathToNameFiles (@mdName int, @Path varchar(256))
	RETURNS INT as begin
		EXECUTE master.dbo.xp_mdNameSetPathToNameFiles @mdName, @Path
		RETURN NULL
	END
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameInitializeDataFiles') AND type='FN')
BEGIN
  DROP FUNCTION mdNameInitializeDataFiles
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameInitializeDataFiles') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	CREATE FUNCTION mdNameInitializeDataFiles (@mdName int)
	returns int as begin
		declare @RetVal int
		execute master.dbo.xp_mdNameInitializeDataFiles @RetVal out, @mdName
		return @RetVal
	end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetInitializeErrorString') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetInitializeErrorString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetInitializeErrorString') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	create function mdNameGetInitializeErrorString (@mdName int)
	returns varchar(256) as begin
		declare @RetVal varchar(256)
		execute master.dbo.xp_mdNameGetInitializeErrorString @RetVal out, @mdName
		return @RetVal
	end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetLicenseString') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetLicenseString
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetLicenseString') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	create function mdNameSetLicenseString (@mdName int, @License varchar(256))
	returns int as begin
		declare @RetVal int
		execute master.dbo.xp_mdNameSetLicenseString @RetVal out, @mdName, @License
		return @RetVal
	end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetBuildNumber') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetBuildNumber
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetBuildNumber') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetBuildNumber (@mdName int)
			returns varchar(256) as begin
			declare @RetVal varchar(256)
			execute master.dbo.xp_mdNameGetBuildNumber @RetVal out, @mdName
			return @RetVal
		end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetDatabaseDate') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetDatabaseDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetDatabaseDate') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetDatabaseDate (@mdName int)
			returns varchar(256) as begin
			declare @RetVal varchar(256)
			execute master.dbo.xp_mdNameGetDatabaseDate @RetVal out, @mdName
			return @RetVal
		end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetDatabaseExpirationDate') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetDatabaseExpirationDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetDatabaseExpirationDate') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetDatabaseExpirationDate (@mdName int)
			returns varchar(256) as begin
			declare @RetVal varchar(256)
			execute master.dbo.xp_mdNameGetDatabaseExpirationDate @RetVal out, @mdName
			return @RetVal
		end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetLicenseExpirationDate') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetLicenseExpirationDate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetLicenseExpirationDate') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetLicenseExpirationDate (@mdName int)
			returns varchar(256) as begin
			declare @RetVal varchar(256)
			execute master.dbo.xp_mdNameGetLicenseExpirationDate @RetVal out, @mdName
			return @RetVal
		end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPrimaryNameHint') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetPrimaryNameHint
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPrimaryNameHint') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetPrimaryNameHint (@mdName int, @NameHint int)
			returns int as begin
				declare @RetVal int
				execute master.dbo.xp_mdNameSetPrimaryNameHint @RetVal out, @mdName, @NameHint
				return @RetVal
		end
	' 
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSecondaryNameHint') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetSecondaryNameHint
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSecondaryNameHint') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetSecondaryNameHint (@mdName int, @NameHint int)
			returns int as begin
				declare @RetVal int
				execute master.dbo.xp_mdNameSetSecondaryNameHint @RetVal out, @mdName, @NameHint
				return @RetVal
		end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFirstNameSpellingCorrection') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetFirstNameSpellingCorrection
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFirstNameSpellingCorrection') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	create function mdNameSetFirstNameSpellingCorrection (@mdName int, @Status int)
		returns int as begin
			declare @RetVal int
			execute master.dbo.xp_mdNameSetFirstNameSpellingCorrection @RetVal out, @mdName, @Status
			return @RetVal
		end
    '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetGenderPopulation') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetGenderPopulation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetGenderPopulation') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	create function mdNameSetGenderPopulation (@mdName int, @Population int)
	returns int as begin
		declare @RetVal int
		execute master.dbo.xp_mdNameSetGenderPopulation @RetVal out, @mdName, @Population
		return @RetVal
	end
    '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetGenderAggression') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetGenderAggression
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetGenderAggression') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	create function mdNameSetGenderAggression (@mdName int, @Aggression int)
		returns int as begin
			declare @RetVal int
			execute master.dbo.xp_mdNameSetGenderAggression @RetVal out, @mdName, @Aggression
			return @RetVal
		end
    '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameAddSalutation') AND type='FN')
BEGIN
  DROP FUNCTION mdNameAddSalutation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameAddSalutation') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameAddSalutation (@mdName int, @Salutation int)
		returns int as begin
			declare @RetVal int
			execute master.dbo.xp_mdNameAddSalutation @RetVal out, @mdName, @Salutation
			return @RetVal
		end
    '
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSalutationPrefix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetSalutationPrefix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSalutationPrefix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetSalutationPrefix (@mdName int, @Prefix varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetSalutationPrefix @mdName, @Prefix
				return NULL
			end
		'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSalutationSuffix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetSalutationSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSalutationSuffix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetSalutationSuffix (@mdName int, @Suffix varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetSalutationSuffix @mdName, @Suffix
				return NULL
			end
		'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSalutationSlug') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetSalutationSlug
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSalutationSlug') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetSalutationSlug (@mdName int, @Slug varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetSalutationSlug @mdName, @Slug
				return NULL
			end
		'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameClearProperties') AND type='FN')
BEGIN
  DROP FUNCTION mdNameClearProperties
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameClearProperties') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameClearProperties (@mdName int)
			returns int as begin
				execute master.dbo.xp_mdNameClearProperties @mdName
				return NULL
			end
		'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFullName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetFullName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFullName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetFullName (@mdName int, @Name varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetFullName @mdName, @Name
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPrefix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetPrefix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPrefix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetPrefix (@mdName int, @Prefix varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetPrefix @mdName, @Prefix
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPrefix2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetPrefix2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetPrefix2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetPrefix2 (@mdName int, @Prefix2 varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetPrefix2 @mdName, @Prefix2
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFirstName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetFirstName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFirstName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetFirstName (@mdName int, @First varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetFirstName @mdName, @First
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFirstName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetFirstName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetFirstName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetFirstName2 (@mdName int, @First varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetFirstName2 @mdName, @First
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetMiddleName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetMiddleName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetMiddleName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetMiddleName (@mdName int, @Middle varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetMiddleName @mdName, @Middle
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetMiddleName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetMiddleName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetMiddleName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetMiddleName2 (@mdName int, @Middle varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetMiddleName2 @mdName, @Middle
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetLastName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetLastName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetLastName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetLastName (@mdName int, @Last varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetLastName @mdName, @Last
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetLastName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetLastName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetLastName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetLastName2 (@mdName int, @Last varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetLastName2 @mdName, @Last
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSuffix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSuffix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetSuffix (@mdName int, @Suffix varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetSuffix @mdName, @Suffix
				return NULL
			end
	'
END
GO



IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSuffix2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetSuffix2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetSuffix2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetSuffix2 (@mdName int, @Suffix varchar(4096))
			returns int as begin
				execute master.dbo.xp_mdNameSetSuffix2 @mdName, @Suffix
				return NULL
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameStandardizeCompany') AND type='FN')
BEGIN
  DROP FUNCTION mdNameStandardizeCompany
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameStandardizeCompany') AND type='FN')
BEGIN
    EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameStandardizeCompany (@mdName int, @Company varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameStandardizeCompany @RetVal out, @mdName, @Company
				return @RetVal
			end
	'
END	
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetMiddleNameLogic') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSetMiddleNameLogic
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSetMiddleNameLogic') AND type='FN')
BEGIN
    EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSetMiddleNameLogic (@mdName int, @Logic int)
			returns int as begin
				declare @RetVal as int
				execute master.dbo.xp_mdNameSetMiddleNameLogic @RetVal out, @mdName, @Logic
				return @RetVal
			end
	'
END	
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParse') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParse
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParse') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParse (@mdName int)
			returns int as begin
				declare @RetVal as int
				execute master.dbo.xp_mdNameParse @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderize') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGenderize
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderize') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGenderize (@mdName int)
			returns int as begin
				declare @RetVal as int
				execute master.dbo.xp_mdNameGenderize @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutate') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSalutate
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutate') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSalutate (@mdName int)
			returns int as begin
				declare @RetVal as int
				execute master.dbo.xp_mdNameSalutate @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetStatusCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetStatusCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetStatusCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetStatusCode (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetStatusCode @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetErrorCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetErrorCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetErrorCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetErrorCode (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetErrorCode @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetChangeCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetChangeCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetChangeCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetChangeCode (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetChangeCode @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetResults') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetResults
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetResults') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetResults (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetResults @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetPrefix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetPrefix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetPrefix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetPrefix (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetPrefix @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetPrefix2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetPrefix2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetPrefix2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetPrefix2 (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetPrefix2 @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetFirstName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetFirstName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetFirstName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetFirstName (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetFirstName @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetFirstName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetFirstName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetFirstName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetFirstName2 (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetFirstName2 @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetMiddleName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetMiddleName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetMiddleName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetMiddleName (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetMiddleName @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetMiddleName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetMiddleName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetMiddleName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetMiddleName2 (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetMiddleName2 @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetLastName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetLastName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetLastName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetLastName (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetLastName @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetLastName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetLastName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetLastName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetLastName2 (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetLastName2 @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetSuffix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetSuffix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetSuffix (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetSuffix @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetSuffix2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetSuffix2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetSuffix2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetSuffix2 (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetSuffix2 @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetGender') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetGender
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetGender') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetGender (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetGender @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetGender2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetGender2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetGender2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetGender2 (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetGender2 @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetSalutation') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGetSalutation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGetSalutation') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGetSalutation (@mdName int)
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGetSalutation @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParsePrefix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParsePrefix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParsePrefix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParsePrefix (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParsePrefix @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParsePrefix2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParsePrefix2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParsePrefix2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParsePrefix2 (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParsePrefix2 @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseFirstName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseFirstName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseFirstName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseFirstName (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseFirstName @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseFirstName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseFirstName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseFirstName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseFirstName2 (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseFirstName2 @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseMiddleName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseMiddleName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseMiddleName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseMiddleName (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseMiddleName @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseMiddleName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseMiddleName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseMiddleName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseMiddleName2 (@mdName int, @Name varchar(4096))
		returns varchar(4096) as begin
			declare @RetVal as varchar(4096)
			execute master.dbo.xp_mdNameParseMiddleName2 @RetVal out, @mdName, @Name
			return @RetVal
		end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseLastName') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseLastName
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseLastName') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseLastName (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseLastName @RetVal out, @mdName, @Name
				return @RetVal
			end	
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseLastName2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseLastName2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseLastName2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
	create function mdNameParseLastName2 (@mdName int, @Name varchar(4096))
		returns varchar(4096) as begin
			declare @RetVal as varchar(4096)
			execute master.dbo.xp_mdNameParseLastName2 @RetVal out, @mdName, @Name
			return @RetVal
		end	
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseSuffix') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseSuffix
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseSuffix') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseSuffix (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseSuffix @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseSuffix2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseSuffix2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseSuffix2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseSuffix2 (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseSuffix2 @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseGender') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseGender
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseGender') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseGender (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseGender @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseGender2') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseGender2
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseGender2') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseGender2 (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseGender2 @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseSalutation') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseSalutation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseSalutation') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseSalutation (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseSalutation @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseStatusCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseStatusCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseStatusCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseStatusCode (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseStatusCode @RetVal out, @mdName
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseErrorCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseErrorCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseErrorCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseErrorCode (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseErrorCode @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseChangeCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseChangeCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseChangeCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseChangeCode (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseChangeCode @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseResults') AND type='FN')
BEGIN
  DROP FUNCTION mdNameParseResults
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameParseResults') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameParseResults (@mdName int, @Name varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameParseResults @RetVal out, @mdName, @Name
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeGender') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGenderizeGender
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeGender') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGenderizeGender (@mdName int, @Prefix varchar(4096), @FirstName varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGenderizeGender @RetVal out, @mdName, @Prefix, @FirstName, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeStatusCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGenderizeStatusCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeStatusCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGenderizeStatusCode (@mdName int, @Prefix varchar(4096), @FirstName varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGenderizeStatusCode @RetVal out, @mdName, @Prefix, @FirstName, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeErrorCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGenderizeErrorCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeErrorCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGenderizeErrorCode (@mdName int, @Prefix varchar(4096), @FirstName varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGenderizeErrorCode @RetVal out, @mdName, @Prefix, @FirstName, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeChangesCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGenderizeChangesCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeChangesCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGenderizeChangesCode (@mdName int, @Prefix varchar(4096), @FirstName varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGenderizeChangeCode @RetVal out, @mdName, @Prefix, @FirstName, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeResults') AND type='FN')
BEGIN
  DROP FUNCTION mdNameGenderizeResults
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameGenderizeResults') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameGenderizeResults (@mdName int, @Prefix varchar(4096), @FirstName varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameGenderizeResults @RetVal out, @mdName, @Prefix, @FirstName, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateSalutation') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSalutateSalutation
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateSalutation') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSalutateSalutation (@mdName int, @Prefix varchar(4096), @FirstName varchar(4096), @LastName varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameSalutateSalutation @RetVal out, @mdName, @Prefix, @FirstName, @LastName, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateStatusCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSalutateStatusCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateStatusCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSalutateStatusCode (@mdName int, @Prefix varchar(4096), @First varchar(4096), @Last varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameSalutateStatusCode @RetVal out, @mdName, @Prefix, @First, @Last, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateErrorCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSalutateErrorCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateErrorCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSalutateErrorCode (@mdName int, @Prefix varchar(4096), @First varchar(4096), @Last varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameSalutateErrorCode @RetVal out, @mdName, @Prefix, @First, @Last, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateChangeCode') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSalutateChangeCode
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateChangeCode') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSalutateChangeCode (@mdName int, @Prefix varchar(4096), @First varchar(4096), @Last varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameSalutateChangeCode @RetVal out, @mdName, @Prefix, @First, @Last, @Suffix
				return @RetVal
			end
	'
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateResults') AND type='FN')
BEGIN
  DROP FUNCTION mdNameSalutateResults
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('mdNameSalutateResults') AND type='FN')
BEGIN
	EXECUTE dbo.sp_executesql @Statement=N'
		create function mdNameSalutateResults (@mdName int, @Prefix varchar(4096), @First varchar(4096), @Last varchar(4096), @Suffix varchar(4096))
			returns varchar(4096) as begin
				declare @RetVal as varchar(4096)
				execute master.dbo.xp_mdNameSalutateResults @RetVal out, @mdName, @Prefix, @First, @Last, @Suffix
				return @RetVal
			end
	'
END
GO
